/////////////////////////////////////////////////////////////////////////////////

// Original obtained from ShaderToy.com
// Adapted, trivialy, for VGHD by TheEmu.

uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

// Use defines here rather than edit the body of the code.

#define iGlobalTime u_Elapsed
#define iResolution u_WindowSize
#define iMouse AUTO_MOUSE

/////////////////////////////////////////////////////////////////////////////////

// Simple "Automatic Mouse". Simulates scanning the mouse over the full range of
// the screen with the X and Y scanning frequencies being different. TheEmu.

#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
#define MOUSE_POS   vec2((1.0+cos(iGlobalTime*MOUSE_SPEED))*u_WindowSize/2.0)
#define MOUSE_PRESS vec2(0.0,0.0)
#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )

/////////////////////////////////////////////////////////////////////////////////

// The ShaderToy shaders often use textures as inputs named iChannel0. With VGHD
// this may access a Sprite, ClipSprite or ClipNameSprite image depending on how
// the .scn file declares them.
//
// Note, the name used here does not seem to make any difference, so I have used
// iChannel0 which is what is used by ShaderToy but you can use any name as long
// as it matches the use in the main body of the shader. TheEmu.

uniform sampler2D iChannel0;

// With VGHD the range of the P argument's components of the texture functions is
// 0.0 to 1.0 whereas with ShaderToy it seems that the upper limits are given  by
// the number of pixels in each direction, typically 512 or 64.  We therefore use
// the following functions instead.

vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}

// Rather than edit the body of the original shader we use use a define  here  to
// redirect texture calls to the above functions.

#define texture2D texture2D_Fract

/////////////////////////////////////////////////////////////////////////////////

uniform int N1; // was #define it 24 - TheEmu
uniform int N2; // was hard coded 55 - TheEmu

float t=iGlobalTime*.04;

float sphere(vec3 p, vec3 rd, float r){
   float b = dot( -p, rd );
   float inner = b * b - dot( p, p ) + r * r;
   if( inner < 0.0 ) return -1.0;
   float s=sqrt(inner);
   return b - s;
}


mat2 rot(float a) {
   float c=cos(a), s=sin(a);
   return mat2(c,s,-s,c);
}

vec3 kset(in vec3 p) {
    p+=sin(p*100.+iGlobalTime*8.)*.0005;
    p*=.74;
    p=abs(1.-mod(p,2.));
    vec3 cp=vec3(0.);
    float c=1000.;
    for (int i=0; i<N1; i++) {
      float dd=dot(p,p);
      vec3 p2=p;
      p=abs(p);
      p=p/dd-1.;
      cp+=exp(-50.*abs(p-p2*.5));
      c=min(c,dd);
   }
   c=pow(max(0.,.2-c)/.2,5.);
   return cp*.03+c*.3;
}



void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
   float mono=1.-texture2D(iChannel0,vec2(32./256.,.75)).x;
   vec2 uv = gl_FragCoord.xy / iResolution.xy-.5;
   uv.x*=iResolution.x/iResolution.y;
   vec2 mo=iMouse.z>.1?iMouse.xy/iResolution.xy-.5:vec2(0.);
   vec3 ro=vec3(-mo,-1.5-sin(t*3.7562)*.3);
   vec3 rd=normalize(vec3(uv,1.));
   vec3 v=vec3(0.);
   float x=mo.x*2.+t; float y=mo.y*3.+t*2.;
   mat2 rot1=rot(x);
   mat2 rot2=rot(y);
   float f=1.;
   rd.xy*=rot(.3);
   ro.xy*=rot(.3);
   ro.xz*=rot1;
   rd.xz*=rot1;
   ro.yz*=rot2;
   rd.yz*=rot2;
   float c=0.;
   for (int i=0; i<N2; i++) {
     float tt=sphere(ro, rd, 1.0-float(i)*.002);
     vec3 p=ro+rd*tt;
     vec3 n=normalize(rd-ro);
     vec3 k=kset(p)*step(0.,tt)*f;
     v+=k*pow(max(0.,dot(rd,n)),8.);
     f*=max(0.5,1.-length(k)*3.5);
   }
   vec3 vv = vec3(length(v)) * vec3(1.2,1.1,0.8); // Tweaked to make it
   fragColor.rgb = 2.0*mix(vv,v,0.6*mono);        // both brighter and
   fragColor.a = length(fragColor.rgb);           // translucent - TheEmu.
}

void main ( void )
 { mainImage ( gl_FragColor, gl_FragCoord.xy );
 }
